%% quadratic polynomial function: Equation 33

function [H]  = Chen_b_cny_j_Poly(srw, mu_cn, mu_rw, beta, tau, r, bbar_cny, b_cny_rw)

psw = 1-srw;

Psi = mu_rw*psw;

Omega = (beta*tau)/((1+tau)*r);

First_term = (bbar_cny * (Omega^(2)) + (mu_cn-Psi) * Omega + (mu_cn+Psi) * (Omega^(2))) * (b_cny_rw^(2)) ;

Second_term = (2 * bbar_cny * (Omega^(2)) * psw + (mu_cn+Psi) * psw + 2 * (mu_cn-Psi) * Omega * psw + 2 * (mu_cn+Psi)...
    * (Omega^(2)) * psw) * b_cny_rw;

Third_term = bbar_cny * (Omega^(2)) * (psw)^(2) - bbar_cny * (psw)^(2) + (mu_cn-Psi) * Omega * (psw)^(2) ...
    + (mu_cn+Psi) * (Omega^(2)) * (psw)^(2);

H = First_term + Second_term + Third_term;

end